# -*- coding: utf-8 -*-
"""
Created on Thu Sep 20 15:12:58 2018

@author: Kanazawa
"""

def CreateChromatoHeader(number, name):
    header = name + number + " (input)\n" 
    header += "[MS Chromatogram]\n"
    header += "R.Time(min)\tAbsolute Intensity\n"
    return header
    
def CreateChromatoTextFile(f, time, chromato, number, name = "augmentation# "):
    f.write(CreateChromatoHeader(number, name))
    assert(len(time) == len(chromato))
    for i in range(len(time)):
        f.write(str(time[i]))
        f.write('\t')
        f.write(str(chromato[i]))
        f.write('\n')
    f.write('\n')
       
def CreatePeakTableHeader(number, name):
    header = name + number + " (output)\n" 
    header += "[Peak Table]\n"
    header += "Peak#\tR.Time(min)\tStart Time(min)\tStart Intensity\tEnd Time(min)\tEnd Intensity\tCompound Name\n"
    return header
    
def CreatePeakTableTextFile(f, peakTables, number, name = "augmentation# "):
    f.write(CreatePeakTableHeader(number, name))
    for i in range(len(peakTables)):
        f.write(str(i + 1))
        peakTable = peakTables[i]
        f.write('\t' + str(peakTable[0]) + '\t' + str(peakTable[1]) + '\t' 
                + str(peakTable[2]) + '\t' + str(peakTable[3])  
                + '\t' + str(peakTable[4]) + '\t' + peakTable[5])
        f.write('\n')