# -*- coding: utf-8 -*-
"""
Created on Tue Aug  7 14:39:08 2018

@author: Kanazawa
"""
import numpy as np
import matplotlib.pyplot as plt

def ASTM(time, baseline, interval = 0.5):
    time = np.array(time)
    if(time[-1] - time[0] < interval):
        return 0.0
        
    baseline = np.array(baseline)
    localNoises = np.array([])
    numOfLoop = int((time[-1] - time[0]) // interval + 1)
    for i in range(numOfLoop):
        startTime = time[0] + i * interval
        endTime = time[0] + (i + 1) * interval
        localIndex = np.logical_and(startTime <= time, time < endTime)
        localTime = time[localIndex]
        if(1 == len(localTime)):
            break
        localBaseline = baseline[localIndex]
        
        func = np.poly1d(np.polyfit(localTime, localBaseline, 1))

        line = func(localTime)
        localNoise = max(localBaseline - line) - min(line - localBaseline)
        localNoises = np.append(localNoises, localNoise)
            
    return np.mean(localNoises)
